/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity.genetics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.breed.Breed;
import sekelsta.horse_colors.client.renderer.TextureLayerGroup;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.genetics.FakeGeneticEntity;
import sekelsta.horse_colors.entity.genetics.IGeneticEntity;
import sekelsta.horse_colors.entity.genetics.Species;
import sekelsta.horse_colors.util.RandomSupplier;

public abstract class Genome {
    public final Species species;
    protected IGeneticEntity entity;
    protected String textureCacheName;
    protected TextureLayerGroup textureLayers;
    protected final RandomSupplier randSource;
    public static Random rand = new Random();

    public abstract List<Enum> listGenes();

    public List<Linkage> listLinkages() {
        ArrayList<Linkage> linkages = new ArrayList<Linkage>();
        for (Enum gene : this.listGenes()) {
            linkages.add(new Linkage(gene));
        }
        return linkages;
    }

    public Genome(Species species, RandomSupplier rand) {
        this(species, new FakeGeneticEntity(), rand);
    }

    public Genome(Species species, IGeneticEntity entityIn, RandomSupplier rand) {
        this.species = species;
        this.entity = entityIn;
        this.randSource = rand;
    }

    public void resetTexture() {
        this.textureCacheName = null;
    }

    public abstract List<List<String>> getBookContents();

    public abstract void setTexturePaths();

    public abstract String genesToString();

    public abstract void genesFromString(String var1);

    public abstract boolean isValidGeneString(String var1);

    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.textureCacheName == null) {
            this.setTexturePaths();
        }
        return this.textureCacheName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureLayerGroup getTexturePaths() {
        if (this.textureCacheName == null) {
            this.setTexturePaths();
        }
        return this.textureLayers;
    }

    @Deprecated
    public abstract int getGeneSize(String var1);

    @Deprecated
    public void setNamedGene(String name, int val, Map<String, Integer> map) {
        String chr = this.getGeneChromosome(name);
        if (map.get(chr) == null) {
            map.put(chr, 0);
        }
        map.put(chr, map.get(chr) & ~this.getGeneLoci(name) | val << this.getGenePos(name) % 32);
    }

    @Deprecated
    public int getNamedGene(String name, Map<String, Integer> map) {
        String chr = this.getGeneChromosome(name);
        if (map.get(chr) == null) {
            map.put(chr, 0);
        }
        return (map.get(chr) & this.getGeneLoci(name)) >>> this.getGenePos(name);
    }

    @Deprecated
    public int getGenePos(String name) {
        return this.getPos(name, this.listGenes());
    }

    @Deprecated
    private int getPos(String name, List<Enum> genes) {
        int i = 0;
        for (Enum gene : genes) {
            int next = i + 2 * this.getGeneSize(gene.toString());
            if (next / 32 != i / 32 && next % 32 != 0) {
                i = (i / 32 + 1) * 32;
            }
            if (gene.toString().equals(name)) {
                return i;
            }
            i += 2 * this.getGeneSize(gene.toString());
        }
        System.out.println("Gene not recognized: " + name);
        return -1;
    }

    @Deprecated
    public int getGeneIndex(String name) {
        int n = 0;
        for (Enum gene : this.listGenes()) {
            if (gene.toString().equals(name)) {
                return n;
            }
            ++n;
        }
        throw new RuntimeException("Unrecognized name");
    }

    @Deprecated
    public int getGeneLoci(String gene) {
        return this.getLoci(gene, this.getGenePos(gene));
    }

    @Deprecated
    private int getLoci(String gene, int pos) {
        return (1 << 2 * this.getGeneSize(gene)) - 1 << pos % 32;
    }

    @Deprecated
    public String getGeneChromosome(String gene) {
        return Integer.toString(this.getGenePos(gene) / 32);
    }

    @Deprecated
    public int getAlleleOld(String name, int n, Map<String, Integer> map) {
        int gene = this.getNamedGene(name, map);
        gene >>= n * this.getGeneSize(name);
        return gene %= 1 << this.getGeneSize(name);
    }

    @Deprecated
    public void setAlleleOld(String name, int n, int v, Map<String, Integer> map) {
        int other = this.getAlleleOld(name, 1 - n, map);
        int size = this.getGeneSize(name);
        this.setNamedGene(name, other << (1 - n) * size | v << n * size, map);
    }

    public int getAllele(Enum gene, int n) {
        int index = 2 * gene.ordinal() + n;
        if (index >= this.entity.getGeneData().length()) {
            return 0;
        }
        return this.entity.getGeneData().charAt(index);
    }

    public void setAllele(Enum gene, int n, int v) {
        int index = 2 * gene.ordinal() + n;
        StringBuffer buffer = new StringBuffer(this.entity.getGeneData());
        if (buffer.length() <= index) {
            buffer.setLength(index + 1);
        }
        buffer.setCharAt(index, (char)v);
        this.entity.setGeneData(new String(buffer));
    }

    public void mutateAllele(Enum gene, int n) {
        Breed breed = this.entity.getDefaultBreed();
        if (!breed.contains(gene)) {
            return;
        }
        List<Float> frequencies = breed.get(gene);
        ArrayList<Integer> allowedAlleles = new ArrayList<Integer>();
        float val = 0.0f;
        for (int i = 0; i < frequencies.size() && !(val >= 1.0f); ++i) {
            if (!(val < frequencies.get(i).floatValue())) continue;
            allowedAlleles.add(i);
            val = frequencies.get(i).floatValue();
        }
        int size = allowedAlleles.size();
        int v = (Integer)allowedAlleles.get(rand.nextInt(size));
        this.setAllele(gene, n, v);
    }

    public void mutateAlleleChance(Enum gene, int n, double p) {
        if (rand.nextDouble() < p) {
            this.mutateAllele(gene, n);
        }
    }

    public void mutate() {
        double p = (Double)HorseConfig.Genetics.mutationChance.get();
        for (Enum gene : this.listGenes()) {
            int a = this.getAllele(gene, 0);
            int b = this.getAllele(gene, 1);
            this.mutateAlleleChance(gene, 0, p);
            this.mutateAlleleChance(gene, 1, p);
        }
    }

    public int sumGenes(Class enumType, String name, int min, int max) {
        int sum = 0;
        for (int i = min; i < max; ++i) {
            Object e = Enum.valueOf(enumType, name + i);
            sum += this.getAllele((Enum)e, 0);
            sum += this.getAllele((Enum)e, 1);
        }
        return sum;
    }

    public boolean hasAllele(Enum gene, int allele) {
        return this.getAllele(gene, 0) == allele || this.getAllele(gene, 1) == allele;
    }

    public int getMaxAllele(Enum gene) {
        return Math.max(this.getAllele(gene, 0), this.getAllele(gene, 1));
    }

    public boolean isHomozygous(Enum gene, int allele) {
        return this.getAllele(gene, 0) == allele && this.getAllele(gene, 1) == allele;
    }

    public int countAlleles(Enum gene, int allele) {
        int count = 0;
        if (this.getAllele(gene, 0) == allele) {
            ++count;
        }
        if (this.getAllele(gene, 1) == allele) {
            ++count;
        }
        return count;
    }

    public void inheritGenes(Genome parent1, Genome parent2) {
        int rand1 = rand.nextInt(2);
        int rand2 = rand.nextInt(2);
        for (Linkage link : this.listLinkages()) {
            int allele1 = parent1.getAllele(link.gene, rand1);
            int allele2 = parent2.getAllele(link.gene, rand2);
            this.setAllele(link.gene, 0, allele1);
            this.setAllele(link.gene, 1, allele2);
            if (rand.nextFloat() < link.p) {
                rand1 = 1 - rand1;
            }
            if (!(rand.nextFloat() < link.p)) continue;
            rand2 = 1 - rand2;
        }
        this.mutate();
    }

    public int getRandom(String key) {
        return this.randSource.getVal(key, this.entity.getSeed());
    }

    public static class Linkage {
        public Enum gene;
        public float p;

        public Linkage(Enum gene, float p) {
            this.gene = gene;
            this.p = p;
        }

        public Linkage(Enum gene) {
            this.gene = gene;
            this.p = 0.5f;
        }
    }
}

